def is_peaceful(word):
    """
    Returns whether a word is peaceful,
    i.e., whether its letters appear in
    sorted order.

    >>> is_peaceful('ABS')
    True
    >>> is_peaceful('FIRST')
    True
    >>> is_peaceful('')
    True
    >>> is_peaceful('PYTHON')
    False
    >>> is_peaceful('CHOCOLATE')
    False
    """
    for i in range(len(word) - 1): # don't check the last letter
        if word[i] >= word[i+1]:
            return False
    return True



def is_stacatto(word):
    """
    Returns whether a word is a stacatto word, i.e.,
    whether the letters in
    even positions are vowels.
    >>> is_stacatto('AUTOMATIC')
    True
    >>> is_stacatto('POPULATE')
    True
    >>> is_stacatto('')
    True
    >>> is_stacatto('PYTHON')
    False
    >>> is_stacatto('SPAGHETTI')
    False
    """
    VOWELS = 'AEIOUY'

    for i in range(len(word)):
        if i % 2 == 1:
            even_letter = word[i]
            if not even_letter in VOWELS:
                return False  # we've found an even letter that isn't a vowel,
                # so we can return immediately.

    return True


def count_peaceful(filename):
    """
    Return the number of peaceful words in the file
    >>> count_peaceful('many_words.txt')
    5
    """
    count = 0
    with open(filename, 'r') as f:
        for line in f:
            word = line.strip().upper()
            if is_peaceful(word):
                count += 1
    return count


def count_stacatto(filename):
    """
     Return the number of stacatto words in the file
    >>> count_stacatto('many_words.txt')
    2
     """
    count = 0
    with open(filename, 'r') as f:
        for line in f:
            word = line.strip().upper()
            if is_stacatto(word):
                count += 1
    return count